<Query Kind="Statements">
  <NuGetReference>Microsoft.CodeAnalysis.CSharp</NuGetReference>
  <Namespace>Microsoft.CodeAnalysis</Namespace>
  <Namespace>Microsoft.CodeAnalysis.CSharp</Namespace>
  <Namespace>Microsoft.CodeAnalysis.CSharp.Syntax</Namespace>
</Query>

var tree = CSharpSyntaxTree.ParseText (@"#define FOO");
SyntaxNode root = tree.GetRoot();

Console.WriteLine (root.ContainsDirectives);      // prawda

// dyrektywa jest węzłem głównym strukturalnego drobiazgu
var directive = root.GetFirstDirective();
Console.WriteLine (directive.Kind());             // DefineDirectiveTrivia
Console.WriteLine (directive.ToString());         // #define FOO

// jeżeli są dostępne kolejne dyrektywy, możemy je otrzymać w poniższy sposób
Console.WriteLine (directive.GetNextDirective());    // (null)

var hashDefine = (DefineDirectiveTriviaSyntax)root.GetFirstDirective();
Console.WriteLine (hashDefine.Name.Text);     // FOO
